	function Phase = PZ_2_PHASE_Z(G, Z, P, wT)

	% Computes the phase response from the poles and zeros for 
	% a digital transfer function at the frequencies specified by wT.

	%	Toolbox for DIGITAL FILTERS USING MATLAB
		
	% Author: 			Lars Wanhammar, 2005-11-04
	% Modified by: 		 
	% Copyright:		by authors - not released for commercial use
	% Version: 			1
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
 
	expjOmega = exp(j*wT);
	if (G < 0) 
		Phase = -pi*ones(1,length(wT));
	else
		Phase = zeros(1,length(wT));
	end
	for n = 1:length(P)
		Phase = Phase - angle(expjOmega-P(n)); 
	end
	for n = 1:length(Z)	
		Phase = Phase + angle(expjOmega-Z(n));
	end	

	for n = 1:length(wT)
		if Phase(n) < -pi
			for m = n:length(wT)
				Phase(m) = Phase(m)+2*pi;
			end
		end
		if Phase(n) > pi
			for m = n:length(wT)
				Phase(m) = Phase(m)-2*pi;
			end
		end
	end
